/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class PermanentsEnteredBattlefieldYourLastTurnWatcher
extends Watcher {
    private final Map<UUID, List<Permanent>> enteringBattlefield = new HashMap<UUID, List<Permanent>>();
    private final Map<UUID, List<Permanent>> enteringBattlefieldLastTurn = new HashMap<UUID, List<Permanent>>();
    private UUID lastActivePlayer = null;

    PermanentsEnteredBattlefieldYourLastTurnWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        this.lastActivePlayer = game.getActivePlayerId();
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            Permanent perm = game.getPermanentEntering(event.getTargetId());
            if (perm == null) {
                perm = game.getPermanent(event.getTargetId());
            }
            if (perm != null) {
                List<Object> permanents;
                if (!this.enteringBattlefield.containsKey(perm.getControllerId())) {
                    permanents = new ArrayList();
                    this.enteringBattlefield.put(perm.getControllerId(), permanents);
                } else {
                    permanents = this.enteringBattlefield.get(perm.getControllerId());
                }
                permanents.add(perm.copy());
            }
        }
    }

    public void reset() {
        super.reset();
        if (this.lastActivePlayer != null && this.enteringBattlefieldLastTurn.get(this.lastActivePlayer) != null) {
            this.enteringBattlefieldLastTurn.remove(this.lastActivePlayer);
        }
        this.enteringBattlefieldLastTurn.putAll(this.enteringBattlefield);
        this.enteringBattlefield.clear();
        this.lastActivePlayer = null;
    }

    public List<Permanent> getPermanentsEnteringOnPlayersLastTurn(Game game, UUID playerId) {
        if (game.isActivePlayer(playerId)) {
            return this.enteringBattlefield.get(playerId);
        }
        return this.enteringBattlefieldLastTurn.get(playerId);
    }
}

