/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class WellEffect
extends OneShotEffect {
    public WellEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain 2 life for each creature you control";
    }

    private WellEffect(WellEffect effect) {
        super((OneShotEffect)effect);
    }

    public WellEffect copy() {
        return new WellEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int life = 2 * game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game);
            player.gainLife(life, game, source);
        }
        return true;
    }
}

