/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.b.BackForMoreDamageEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class BackForMoreEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature you don't control");

    BackForMoreEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target creature card from your graveyard to the battlefield. When you do, it fights up to one target creature you don't control. <i>(Each deals damage equal to its power to the other.)</i>";
    }

    private BackForMoreEffect(BackForMoreEffect effect) {
        super((OneShotEffect)effect);
    }

    public BackForMoreEffect copy() {
        return new BackForMoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new BackForMoreDamageEffect(new MageObjectReference((MageObject)permanent, game)), false, "it fights up to one target creature you don't control");
        ability.addTarget((Target)new TargetPermanent(0, 1, filter, false));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
    }
}

