/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class BackForSecondsEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    BackForSecondsEffect() {
        super(Outcome.Benefit);
    }

    private BackForSecondsEffect(BackForSecondsEffect effect) {
        super((OneShotEffect)effect);
    }

    public BackForSecondsEffect copy() {
        return new BackForSecondsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        TargetCardInYourGraveyard target;
        boolean chosen;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Target target2 : source.getTargets()) {
            for (UUID id : target2.getTargets()) {
                cards.add((Object)id);
            }
        }
        cards.retainZone(Zone.GRAVEYARD, game);
        if (cards.count(filter, game) > 0 && (chosen = controller.choose(Outcome.PutCreatureInPlay, (Cards)cards, (TargetCard)(target = new TargetCardInYourGraveyard(0, 1, filter, true)), source, game)) && (card = game.getCard(target.getFirstTarget())) != null) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            cards.remove(card);
        }
        controller.moveCardsToHandWithInfo((Cards)cards, source, game, true);
        return true;
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, 4));
    }
}

