/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class BalanceOfPowerEffect
extends OneShotEffect {
    BalanceOfPowerEffect() {
        super(Outcome.DrawCard);
        this.staticText = "If target opponent has more cards in hand than you, draw cards equal to the difference";
    }

    private BalanceOfPowerEffect(BalanceOfPowerEffect effect) {
        super((OneShotEffect)effect);
    }

    public BalanceOfPowerEffect copy() {
        return new BalanceOfPowerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (opponent != null && player != null && opponent.getHand().size() > player.getHand().size()) {
            player.drawCards(opponent.getHand().size() - player.getHand().size(), source, game);
            return true;
        }
        return false;
    }
}

