/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.GravebornToken;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BalduvianDeadEffect
extends OneShotEffect {
    BalduvianDeadEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a 3/1 black and red Graveborn creature token with haste. Sacrifice it at the beginning of the next end step";
    }

    private BalduvianDeadEffect(BalduvianDeadEffect effect) {
        super((OneShotEffect)effect);
    }

    public BalduvianDeadEffect copy() {
        return new BalduvianDeadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenEffect effect = new CreateTokenEffect((Token)new GravebornToken());
        effect.apply(game, source);
        for (UUID tokenId : effect.getLastAddedTokenIds()) {
            Permanent tokenPermanent = game.getPermanent(tokenId);
            if (tokenPermanent == null) continue;
            SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("Sacrifice the token at the beginning of the next end step", source.getControllerId());
            sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(tokenPermanent, game));
            AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
        }
        return true;
    }
}

