/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;

class BalduvianFallenAbility
extends TriggeredAbilityImpl {
    public BalduvianFallenAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private BalduvianFallenAbility(BalduvianFallenAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BalduvianFallenAbility copy() {
        return new BalduvianFallenAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PAID_CUMULATIVE_UPKEEP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        this.getEffects().clear();
        if (event.getTargetId().equals(this.getSourceId()) && event instanceof ManaEvent) {
            ManaEvent manaEvent = (ManaEvent)event;
            int total = manaEvent.getMana().getBlack() + manaEvent.getMana().getRed();
            if (total > 0) {
                this.getEffects().add((Object)new BoostSourceEffect(total, 0, Duration.EndOfTurn));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this}'s cumulative upkeep is paid, it gets +1/+0 until end of turn for each {B} or {R} spent this way.";
    }
}

