/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.RemoveFromCombatTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.BlockerDeclaredEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.watchers.common.BlockedByOnlyOneCreatureThisCombatWatcher;

class BalduvianWarlordUnblockEffect
extends OneShotEffect {
    BalduvianWarlordUnblockEffect() {
        super(Outcome.Benefit);
        this.staticText = "Remove target blocking creature from combat. Creatures it was blocking that hadn't become blocked by another creature this combat become unblocked, then it blocks an attacking creature of your choice";
    }

    private BalduvianWarlordUnblockEffect(BalduvianWarlordUnblockEffect effect) {
        super((OneShotEffect)effect);
    }

    public BalduvianWarlordUnblockEffect copy() {
        return new BalduvianWarlordUnblockEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getTargets().getFirstTarget());
        if (controller != null && permanent != null) {
            Set combatGroups;
            RemoveFromCombatTargetEffect effect = new RemoveFromCombatTargetEffect();
            effect.apply(game, source);
            BlockedByOnlyOneCreatureThisCombatWatcher watcher = (BlockedByOnlyOneCreatureThisCombatWatcher)game.getState().getWatcher(BlockedByOnlyOneCreatureThisCombatWatcher.class);
            if (watcher != null && (combatGroups = watcher.getBlockedOnlyByCreature(permanent.getId())) != null) {
                for (CombatGroup combatGroup : combatGroups) {
                    if (combatGroup == null) continue;
                    combatGroup.setBlocked(false, game);
                }
            }
            if (permanent.isCreature(game)) {
                ArrayList<Permanent> list = new ArrayList<Permanent>();
                for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                    if (!combatGroup.getDefendingPlayerId().equals(permanent.getControllerId())) continue;
                    for (UUID attackingCreatureId : combatGroup.getAttackers()) {
                        Permanent targetsControllerAttacker = game.getPermanent(attackingCreatureId);
                        list.add(targetsControllerAttacker);
                    }
                }
                Player targetsController = game.getPlayer(permanent.getControllerId());
                if (targetsController != null) {
                    CombatGroup chosenGroup;
                    FilterAttackingCreature filter = new FilterAttackingCreature("creature attacking " + targetsController.getLogName());
                    filter.add((Predicate)new PermanentReferenceInCollectionPredicate(list, game));
                    TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                    target.withNotTarget(true);
                    if (!controller.chooseTarget(this.outcome, (Target)target, source, game)) {
                        return true;
                    }
                    Permanent chosenPermanent = game.getPermanent(target.getFirstTarget());
                    if (chosenPermanent != null && chosenPermanent.isCreature(game) && (chosenGroup = game.getCombat().findGroup(chosenPermanent.getId())) != null) {
                        boolean notYetBlocked = chosenGroup.getBlockers().isEmpty();
                        chosenGroup.addBlockerToGroup(permanent.getId(), controller.getId(), game);
                        game.getCombat().addBlockingGroup(permanent.getId(), chosenPermanent.getId(), controller.getId(), game);
                        if (notYetBlocked) {
                            game.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.CREATURE_BLOCKED, (UUID)chosenPermanent.getId(), (Ability)source, null));
                            HashSet<MageObjectReference> morSet = new HashSet<MageObjectReference>();
                            morSet.add(new MageObjectReference((MageObject)chosenPermanent, game));
                            for (UUID bandedId : chosenPermanent.getBandedCards()) {
                                CombatGroup bandedGroup = game.getCombat().findGroup(bandedId);
                                if (bandedGroup == null || chosenGroup.getBlockers().size() != 1) continue;
                                morSet.add(new MageObjectReference(bandedId, game));
                                game.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.CREATURE_BLOCKED, (UUID)bandedId, (Ability)source, null));
                            }
                            String key = UUID.randomUUID().toString();
                            game.getState().setValue("becameBlocked_" + key, morSet);
                            game.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.BATCH_BLOCK_NONCOMBAT, (UUID)source.getSourceId(), (Ability)source, (UUID)source.getControllerId(), (String)key, (int)0));
                        }
                        game.fireEvent((GameEvent)new BlockerDeclaredEvent(chosenPermanent.getId(), permanent.getId(), permanent.getControllerId()));
                        game.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.CREATURE_BLOCKS, (UUID)permanent.getId(), (Ability)source, null));
                    }
                }
                return true;
            }
        }
        return false;
    }
}

