/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class BalefulMasteryAlternativeCostEffect
extends OneShotEffect {
    private final UUID alternativeCostOriginalID;

    BalefulMasteryAlternativeCostEffect(UUID alternativeCostOriginalID) {
        super(Outcome.Detriment);
        this.staticText = "if the {1}{B} cost was paid, an opponent draws a card.<br>";
        this.alternativeCostOriginalID = alternativeCostOriginalID;
    }

    private BalefulMasteryAlternativeCostEffect(BalefulMasteryAlternativeCostEffect effect) {
        super((OneShotEffect)effect);
        this.alternativeCostOriginalID = effect.alternativeCostOriginalID;
    }

    public BalefulMasteryAlternativeCostEffect copy() {
        return new BalefulMasteryAlternativeCostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent;
        TargetOpponent targetOpponent;
        if (!AlternativeCostSourceAbility.getActivatedStatus((Game)game, (Ability)source, (UUID)this.alternativeCostOriginalID, (boolean)false)) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player.chooseTarget(Outcome.DrawCard, (Target)(targetOpponent = new TargetOpponent(true)), source, game) && (opponent = game.getPlayer(targetOpponent.getFirstTarget())) != null) {
            opponent.drawCards(1, source, game);
            return true;
        }
        return false;
    }
}

