/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class BalustradeSpyEffect
extends OneShotEffect {
    BalustradeSpyEffect() {
        super(Outcome.Discard);
        this.staticText = "target player reveals cards from the top of their library until they reveal a land card, then puts those cards into their graveyard";
    }

    private BalustradeSpyEffect(BalustradeSpyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BalustradeSpyEffect copy() {
        return new BalustradeSpyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null) {
            return false;
        }
        CardsImpl toGraveyard = new CardsImpl();
        for (Card card : controller.getLibrary().getCards(game)) {
            if (card == null) continue;
            toGraveyard.add(card);
            if (!card.isLand(game)) continue;
            break;
        }
        controller.revealCards(source, (Cards)toGraveyard, game);
        controller.moveCards((Cards)toGraveyard, Zone.GRAVEYARD, source, game);
        return true;
    }
}

