/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class BanditsTalentDiscardEffect
extends OneShotEffect {
    BanditsTalentDiscardEffect() {
        super(Outcome.Discard);
        this.staticText = "each opponent discards two cards unless they discard a nonland card";
    }

    private BanditsTalentDiscardEffect(BanditsTalentDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public BanditsTalentDiscardEffect copy() {
        return new BanditsTalentDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        HashMap<UUID, CardsImpl> cardsToDiscard = new HashMap<UUID, CardsImpl>();
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            TargetDiscard target;
            Player targetPlayer = game.getPlayer(playerId);
            if (targetPlayer == null || targetPlayer.getHand().isEmpty() || !controller.hasOpponent(playerId, game)) continue;
            int numberOfCardsToDiscard = Math.min(2, targetPlayer.getHand().size());
            CardsImpl cards = new CardsImpl();
            if (numberOfCardsToDiscard <= 0) continue;
            if (targetPlayer.getHand().count((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game) < 1 || !targetPlayer.chooseUse(Outcome.Discard, "Discard a nonland card?", source, game)) {
                target = new TargetDiscard(numberOfCardsToDiscard, numberOfCardsToDiscard, StaticFilters.FILTER_CARD, playerId);
                targetPlayer.chooseTarget(this.outcome, (Target)target, source, game);
                cards.addAll((Collection)target.getTargets());
            } else {
                target = new TargetDiscard(1, 1, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND, playerId);
                targetPlayer.chooseTarget(this.outcome, (Target)target, source, game);
                cards.addAll((Collection)target.getTargets());
            }
            cardsToDiscard.put(playerId, cards);
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.discard((Cards)cardsToDiscard.get(playerId), false, source, game);
        }
        return true;
    }
}

