/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class BaneAlleyBrokerDrawExileEffect
extends OneShotEffect {
    BaneAlleyBrokerDrawExileEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw a card, then exile a card from your hand face down";
    }

    private BaneAlleyBrokerDrawExileEffect(BaneAlleyBrokerDrawExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.drawCards(1, source, game);
        if (controller.getHand().isEmpty()) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand().withChooseHint("to exile");
        controller.chooseTarget(this.outcome, controller.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        if (!controller.moveCardsToExile(card, source, game, false, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source))) {
            return false;
        }
        card.setFaceDown(true, game);
        return true;
    }

    public BaneAlleyBrokerDrawExileEffect copy() {
        return new BaneAlleyBrokerDrawExileEffect(this);
    }
}

