/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class BaneAlleyBrokerReturnToHandEffect
extends OneShotEffect {
    BaneAlleyBrokerReturnToHandEffect() {
        super(Outcome.Benefit);
        this.staticText = "return a card exiled with {this} to its owner's hand";
    }

    private BaneAlleyBrokerReturnToHandEffect(BaneAlleyBrokerReturnToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public BaneAlleyBrokerReturnToHandEffect copy() {
        return new BaneAlleyBrokerReturnToHandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player == null || permanent == null) {
            return false;
        }
        ExileZone exile = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (exile == null || exile.isEmpty()) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile(StaticFilters.FILTER_CARD, exile.getId());
        target.withNotTarget(true);
        player.chooseTarget(this.outcome, (Cards)exile, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        return player.moveCards(card, Zone.HAND, source, game);
    }
}

