/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BaneOfProgressEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public BaneOfProgressEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy all artifacts and enchantments. Put a +1/+1 counter on {this} for each permanent destroyed this way";
    }

    private BaneOfProgressEffect(BaneOfProgressEffect effect) {
        super((OneShotEffect)effect);
    }

    public BaneOfProgressEffect copy() {
        return new BaneOfProgressEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int destroyedPermanents = 0;
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            if (!permanent.destroy(source, game, false)) continue;
            ++destroyedPermanents;
        }
        if (destroyedPermanents > 0) {
            return new AddCountersSourceEffect(CounterType.P1P1.createInstance(destroyedPermanents), true).apply(game, source);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.ENCHANTMENT.getPredicate()));
    }
}

