/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.Objects;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.predicate.mageobject.CommanderPredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;

class BanesContingencyEffect
extends OneShotEffect {
    BanesContingencyEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter target spell. If that spell targets a commander you control, instead counter that spell, scry 2, then draw a card";
    }

    private BanesContingencyEffect(BanesContingencyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BanesContingencyEffect copy() {
        return new BanesContingencyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        boolean flag = spell.getSpellAbility().getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(permanent -> permanent.isControlledBy(source.getControllerId())).anyMatch(permanent -> CommanderPredicate.instance.apply((MageObject)permanent, game));
        game.getStack().counter(spell.getId(), source, game);
        if (!flag) {
            return true;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.scry(2, source, game);
            player.drawCards(1, source, game);
        }
        return true;
    }
}

