/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CastSourceTriggeredAbility;
import mage.cards.b.BanishIntoFableEffect;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;
import mage.watchers.common.CastFromHandWatcher;

class BanishIntoFableTriggeredAbility
extends CastSourceTriggeredAbility {
    BanishIntoFableTriggeredAbility() {
        super(null, false);
        this.addWatcher((Watcher)new CastFromHandWatcher());
        this.setRuleAtTheTop(true);
    }

    private BanishIntoFableTriggeredAbility(BanishIntoFableTriggeredAbility ability) {
        super((CastSourceTriggeredAbility)ability);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!super.checkTrigger(event, game)) {
            return false;
        }
        CastFromHandWatcher watcher = (CastFromHandWatcher)game.getState().getWatcher(CastFromHandWatcher.class);
        if (watcher == null || !watcher.spellWasCastFromHand(event.getSourceId())) {
            return false;
        }
        Spell spell = game.getState().getStack().getSpell(event.getSourceId());
        if (spell == null) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new BanishIntoFableEffect(spell.getId()));
        return true;
    }

    public BanishIntoFableTriggeredAbility copy() {
        return new BanishIntoFableTriggeredAbility(this);
    }

    public String getRule() {
        return "When you cast this spell from your hand, copy it if you control an artifact, then copy it if you control an enchantment. You may choose new targets for the copies.";
    }
}

