/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class BaronVonCountMoveDoomCounterEffect
extends OneShotEffect {
    BaronVonCountMoveDoomCounterEffect() {
        super(Outcome.Neutral);
        this.staticText = "move the doom counter one numeral to the left";
    }

    private BaronVonCountMoveDoomCounterEffect(BaronVonCountMoveDoomCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        MageObject mageObject = game.getObject(source);
        if (controller != null && sourcePermanent != null && mageObject != null) {
            if (game.getState().getValue(mageObject.getId() + "_doom") == null) {
                return false;
            }
            Integer doomNumber = (Integer)game.getState().getValue(mageObject.getId() + "_doom");
            if (doomNumber == 1) {
                game.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.CUSTOM_EVENT, (UUID)source.getSourceId(), (Ability)source, (UUID)controller.getId(), (String)"DoomCounterReset", (int)1));
            }
            if (doomNumber > 0) {
                Integer n = doomNumber;
                Integer n2 = doomNumber = Integer.valueOf(doomNumber - 1);
                game.getState().setValue(mageObject.getId() + "_doom", (Object)doomNumber);
                ((Permanent)mageObject).addInfo("doom counter", CardUtil.addToolTipMarkTags((String)("Doom counter at: " + doomNumber)), game);
            }
            return true;
        }
        return false;
    }

    public BaronVonCountMoveDoomCounterEffect copy() {
        return new BaronVonCountMoveDoomCounterEffect(this);
    }
}

