/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class BaronVonCountPutCounterEffect
extends OneShotEffect {
    BaronVonCountPutCounterEffect() {
        super(Outcome.Benefit);
        this.staticText = "with a doom counter on \"5.\"";
    }

    private BaronVonCountPutCounterEffect(BaronVonCountPutCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent mageObject = game.getPermanentEntering(source.getSourceId());
        if (mageObject == null) {
            mageObject = game.getObject(source);
        }
        if (controller != null && mageObject != null) {
            Integer doomNumber = 5;
            game.getState().setValue(mageObject.getId() + "_doom", (Object)doomNumber);
            if (mageObject instanceof Permanent) {
                mageObject.addInfo("doom counter", CardUtil.addToolTipMarkTags((String)("Doom counter at: " + doomNumber)), game);
                new AddCountersSourceEffect(CounterType.DOOM.createInstance()).apply(game, source);
            }
            return true;
        }
        return false;
    }

    public BaronVonCountPutCounterEffect copy() {
        return new BaronVonCountPutCounterEffect(this);
    }
}

