/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class BarrinsSpiteEffect
extends OneShotEffect {
    BarrinsSpiteEffect() {
        super(Outcome.Detriment);
        this.staticText = "Choose two target creatures controlled by the same player. Their controller chooses and sacrifices one of them. Return the other to its owner's hand";
    }

    private BarrinsSpiteEffect(BarrinsSpiteEffect effect) {
        super((OneShotEffect)effect);
    }

    public BarrinsSpiteEffect copy() {
        return new BarrinsSpiteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        if (permanents.size() == 1) {
            ((Permanent)permanents.get(0)).sacrifice(source, game);
            return true;
        }
        if (permanents.size() > 2) {
            throw new IllegalStateException("Too many permanents in list, shouldn't be possible");
        }
        Player player = game.getPlayer(((Permanent)permanents.get(0)).getControllerId());
        Player controller = game.getPlayer(source.getControllerId());
        if (player == null || controller == null) {
            return false;
        }
        Permanent perm1 = (Permanent)permanents.get(0);
        Permanent perm2 = (Permanent)permanents.get(1);
        if (player.chooseUse(this.outcome, "Choose which permanent to sacrifice", "The other will be returned to your hand", perm1.getIdName(), perm2.getIdName(), source, game)) {
            perm1.sacrifice(source, game);
            controller.moveCards((Card)perm2, Zone.HAND, source, game);
            return true;
        }
        perm2.sacrifice(source, game);
        controller.moveCards((Card)perm1, Zone.HAND, source, game);
        return true;
    }
}

