/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.condition.common.MostCommonColorCondition;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BarrinsUnmakingEffect
extends OneShotEffect {
    BarrinsUnmakingEffect() {
        super(Outcome.Detriment);
        this.staticText = "Return target permanent to its owner's hand if that permanent shares a color with the most common color among all permanents or a color tied for most common.";
    }

    private BarrinsUnmakingEffect(BarrinsUnmakingEffect effect) {
        super((OneShotEffect)effect);
    }

    public BarrinsUnmakingEffect copy() {
        return new BarrinsUnmakingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MostCommonColorCondition condition;
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && (condition = new MostCommonColorCondition(permanent.getColor(game))).apply(game, source)) {
            ReturnToHandTargetEffect effect = new ReturnToHandTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            return effect.apply(game, source);
        }
        return false;
    }
}

