/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.target.TargetSource;

class BeaconOfDestinyEffect
extends RedirectionEffect {
    private final TargetSource damageSource;

    public BeaconOfDestinyEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, RedirectionEffect.UsageType.ONE_USAGE_ABSOLUTE);
        this.staticText = "The next time a source of your choice would deal damage to you this turn, that damage is dealt to {this} instead";
        this.damageSource = new TargetSource();
    }

    private BeaconOfDestinyEffect(BeaconOfDestinyEffect effect) {
        super((RedirectionEffect)effect);
        this.damageSource = effect.damageSource.copy();
    }

    public BeaconOfDestinyEffect copy() {
        return new BeaconOfDestinyEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.damageSource.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        if (object == null) {
            game.informPlayers("Couldn't find source of damage");
            return false;
        }
        if (!(object.getId().equals(this.damageSource.getFirstTarget()) || object instanceof Spell && ((Spell)object).getSourceId().equals(this.damageSource.getFirstTarget()))) {
            return false;
        }
        TargetPermanent target = new TargetPermanent();
        target.add(source.getSourceId(), game);
        this.redirectTarget = target;
        Player player = game.getPlayer(event.getTargetId());
        return player != null && player.getId().equals(source.getControllerId());
    }
}

