/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.b.BeamsplitterMageApplier;
import mage.cards.b.BeamsplitterMagePredicate;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.functions.StackObjectCopyApplier;

class BeamsplitterMageEffect
extends OneShotEffect {
    BeamsplitterMageEffect() {
        super(Outcome.Detriment);
    }

    private BeamsplitterMageEffect(BeamsplitterMageEffect effect) {
        super((OneShotEffect)effect);
    }

    public BeamsplitterMageEffect copy() {
        return new BeamsplitterMageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        if (player == null || spell == null) {
            return false;
        }
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("a creature you control that can be targeted by " + spell.getName());
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((Predicate)new BeamsplitterMagePredicate(spell));
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        spell.createCopyOnStack(game, source, player.getId(), false, 1, (StackObjectCopyApplier)new BeamsplitterMageApplier(permanent, game));
        return true;
    }
}

