/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.BecomesBlockedAllTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.BlockingCreatureCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.EnchantedPredicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class BeastmastersMagemark
extends CardImpl {
    private static final FilterCreaturePermanent filterCreatures = new FilterCreaturePermanent("creatures you control that are enchanted");
    private static final FilterCreaturePermanent filterACreature = new FilterCreaturePermanent("a creature you control that's enchanted");

    public BeastmastersMagemark(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{G}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.AddAbility));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        ability = new SimpleStaticAbility((Effect)new BoostAllEffect(1, 1, Duration.WhileOnBattlefield, filterCreatures, false));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new BecomesBlockedAllTriggeredAbility((Effect)new BoostTargetEffect((DynamicValue)BlockingCreatureCount.TARGET, (DynamicValue)BlockingCreatureCount.TARGET, Duration.EndOfTurn), false, (FilterPermanent)filterACreature, true));
    }

    private BeastmastersMagemark(BeastmastersMagemark card) {
        super((CardImpl)card);
    }

    public BeastmastersMagemark copy() {
        return new BeastmastersMagemark(this);
    }

    static {
        filterCreatures.add((Predicate)EnchantedPredicate.instance);
        filterACreature.add((Predicate)EnchantedPredicate.instance);
        filterCreatures.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filterACreature.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

