/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;

class BeckoningWillOWispEffect
extends OneShotEffect {
    BeckoningWillOWispEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose an opponent";
    }

    private BeckoningWillOWispEffect(BeckoningWillOWispEffect effect) {
        super((OneShotEffect)effect);
    }

    public BeckoningWillOWispEffect copy() {
        return new BeckoningWillOWispEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player == null || permanent == null) {
            return false;
        }
        TargetOpponent target = new TargetOpponent();
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Player chosenPlayer = game.getPlayer(target.getFirstTarget());
        if (chosenPlayer == null) {
            return false;
        }
        game.informPlayers(permanent.getName() + ": " + player.getLogName() + " has chosen " + chosenPlayer.getLogName());
        game.getState().setValue(permanent.getId() + "_" + permanent.getZoneChangeCounter(game) + "_chosenOpponent", (Object)chosenPlayer.getId());
        permanent.addInfo("chosen opponent", CardUtil.addToolTipMarkTags((String)("Chosen player: " + chosenPlayer.getLogName())), game);
        return true;
    }
}

