/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.game.Game;
import mage.target.common.TargetCardInYourGraveyard;

class BeholdTheSinisterSixTarget
extends TargetCardInYourGraveyard {
    private static final FilterCard filter = new FilterPermanentCard("creature cards with different names");

    BeholdTheSinisterSixTarget() {
        super(0, 6, filter, false);
    }

    private BeholdTheSinisterSixTarget(BeholdTheSinisterSixTarget target) {
        super((TargetCardInYourGraveyard)target);
    }

    public BeholdTheSinisterSixTarget copy() {
        return new BeholdTheSinisterSixTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability ability, Game game) {
        if (!super.canTarget(playerId, id, ability, game)) {
            return false;
        }
        Set names = this.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).map(MageObject::getName).filter(Objects::nonNull).collect(Collectors.toSet());
        Card card = game.getCard(id);
        return card != null && (this.getTargets().contains(id) || !names.contains(card.getName()));
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        Set names = this.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).map(MageObject::getName).filter(Objects::nonNull).collect(Collectors.toSet());
        possibleTargets.removeIf(uuid -> {
            Card card = game.getCard(uuid);
            return card != null && names.contains(card.getName());
        });
        return possibleTargets;
    }
}

