/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.b.BelbeCorruptedObserverDynamicValue;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class BelbeCorruptedObserverEffect
extends OneShotEffect {
    BelbeCorruptedObserverEffect() {
        super(Outcome.Benefit);
        this.staticText = "the active player adds {C}{C} for each of your opponents who lost life this turn";
    }

    private BelbeCorruptedObserverEffect(BelbeCorruptedObserverEffect effect) {
        super((OneShotEffect)effect);
    }

    public BelbeCorruptedObserverEffect copy() {
        return new BelbeCorruptedObserverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            return false;
        }
        int playerCount = BelbeCorruptedObserverDynamicValue.instance.calculate(game, source, (Effect)this);
        if (playerCount > 0) {
            player.getManaPool().addMana(Mana.ColorlessMana((int)(2 * playerCount)), game, source);
            return true;
        }
        return false;
    }
}

