/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class BellowingElkWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> playerMap = new HashMap<UUID, Set<UUID>>();

    BellowingElkWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && (zEvent = (ZoneChangeEvent)event).getToZone() == Zone.BATTLEFIELD && zEvent.getTarget().isCreature(game)) {
            this.playerMap.putIfAbsent(zEvent.getTarget().getControllerId(), new HashSet());
            this.playerMap.get(zEvent.getTarget().getControllerId()).add(zEvent.getTargetId());
        }
    }

    public void reset() {
        this.playerMap.clear();
    }

    boolean enteredCreatureForPlayer(UUID playerId, UUID creatureId) {
        Set s = this.playerMap.getOrDefault(playerId, null);
        return s != null && s.stream().anyMatch(id -> id != creatureId);
    }
}

