/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class BellowingMaulerEffect
extends OneShotEffect {
    BellowingMaulerEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "each player loses 4 life unless they sacrifice a nontoken creature";
    }

    private BellowingMaulerEffect(BellowingMaulerEffect effect) {
        super((OneShotEffect)effect);
    }

    public BellowingMaulerEffect copy() {
        return new BellowingMaulerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            boolean sacrificed = false;
            TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_NON_TOKEN);
            if (target.canChoose(playerId, source, game) && player.chooseUse(Outcome.Sacrifice, "Sacrifice a nontoken creature or lose 4 life?", null, "Sacrifice", "Lose 4 life", source, game)) {
                player.choose(Outcome.Sacrifice, (Target)target, source, game);
                Permanent permanent = game.getPermanent(target.getFirstTarget());
                boolean bl = sacrificed = permanent != null && permanent.sacrifice(source, game);
            }
            if (sacrificed) continue;
            player.loseLife(4, game, source, false);
        }
        return true;
    }
}

