/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.SpiritWhiteToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BenevolentOfferingEffect1
extends OneShotEffect {
    BenevolentOfferingEffect1() {
        super(Outcome.Sacrifice);
        this.staticText = "Choose an opponent. You and that player each create three 1/1 white Spirit creature tokens with flying";
    }

    private BenevolentOfferingEffect1(BenevolentOfferingEffect1 effect) {
        super((OneShotEffect)effect);
    }

    public BenevolentOfferingEffect1 copy() {
        return new BenevolentOfferingEffect1(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetOpponent target = new TargetOpponent(true);
        target.choose(Outcome.Sacrifice, source.getControllerId(), source.getSourceId(), source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        CreateTokenTargetEffect effect = new CreateTokenTargetEffect((Token)new SpiritWhiteToken(), 3);
        effect.setTargetPointer((TargetPointer)new FixedTarget(opponent.getId()));
        effect.apply(game, source);
        new CreateTokenEffect((Token)new SpiritWhiteToken(), 3).apply(game, source);
        return true;
    }
}

