/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.Mana;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.choices.Choice;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BenthicExplorersManaEffect
extends ManaEffect {
    BenthicExplorersManaEffect() {
        this.staticText = "Add one mana of any type that land could produce";
    }

    private BenthicExplorersManaEffect(BenthicExplorersManaEffect effect) {
        super((ManaEffect)effect);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        if (game == null) {
            return new ArrayList<Mana>();
        }
        EnumSet<ManaType> manaTypes = EnumSet.noneOf(ManaType.class);
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(opponentId)) {
                if (!permanent.isLand(game) || !permanent.isTapped()) continue;
                for (ActivatedManaAbilityImpl ability : permanent.getAbilities(game).getActivatedManaAbilities(Zone.BATTLEFIELD)) {
                    manaTypes.addAll(ability.getProducableManaTypes(game));
                }
            }
        }
        return ManaType.getManaListFromManaTypes(manaTypes, (boolean)false);
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return mana;
        }
        Choice choice = ManaType.getChoiceOfManaTypes(this.getManaTypes(game, source), (boolean)false);
        if (choice.getChoices().isEmpty()) {
            return mana;
        }
        if (choice.getChoices().size() == 1) {
            choice.setChoice((String)choice.getChoices().iterator().next());
        } else if (!player.choose(Outcome.PutManaInPool, choice, game)) {
            return mana;
        }
        if (choice.getChoice() == null) {
            return mana;
        }
        switch (choice.getChoice()) {
            case "Black": {
                mana.setBlack(1);
                break;
            }
            case "Blue": {
                mana.setBlue(1);
                break;
            }
            case "Red": {
                mana.setRed(1);
                break;
            }
            case "Green": {
                mana.setGreen(1);
                break;
            }
            case "White": {
                mana.setWhite(1);
                break;
            }
            case "Colorless": {
                mana.setColorless(1);
            }
        }
        return mana;
    }

    private Set<ManaType> getManaTypes(Game game, Ability source) {
        EnumSet<ManaType> types = EnumSet.noneOf(ManaType.class);
        if (game == null || game.getPhase() == null) {
            return types;
        }
        List untapped = (List)game.getState().getValue("UntapTargetCost" + source.getSourceId().toString());
        Permanent land = game.getPermanentOrLKIBattlefield((UUID)untapped.get(0));
        if (land == null) {
            return types;
        }
        Abilities mana = land.getAbilities().getActivatedManaAbilities(Zone.BATTLEFIELD);
        for (ActivatedManaAbilityImpl ability : mana) {
            if (!ability.definesMana(game)) continue;
            types.addAll(ability.getProducableManaTypes(game));
        }
        return types;
    }

    public BenthicExplorersManaEffect copy() {
        return new BenthicExplorersManaEffect(this);
    }
}

