/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BereavementTriggeredAbility
extends TriggeredAbilityImpl {
    BereavementTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DiscardTargetEffect(1));
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private BereavementTriggeredAbility(BereavementTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BereavementTriggeredAbility copy() {
        return new BereavementTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (((ZoneChangeEvent)event).isDiesEvent() && (permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD)) != null && permanent.isCreature(game) && permanent.getColor(game).isGreen()) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(permanent.getControllerId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a green creature dies, its controller discards a card.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

