/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.AttackedThisTurnWatcher;

class BerserkDelayedDestroyEffect
extends OneShotEffect {
    BerserkDelayedDestroyEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy that creature if it attacked this turn";
    }

    private BerserkDelayedDestroyEffect(BerserkDelayedDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BerserkDelayedDestroyEffect copy() {
        return new BerserkDelayedDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        AttackedThisTurnWatcher watcher = (AttackedThisTurnWatcher)game.getState().getWatcher(AttackedThisTurnWatcher.class);
        if (watcher == null) {
            return false;
        }
        return watcher.getAttackedThisTurnCreatures().contains(new MageObjectReference((MageObject)permanent, game)) && permanent.destroy(source, game, false);
    }
}

