/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.b.BerserkDelayedDestroyEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BerserkDestroyEffect
extends OneShotEffect {
    BerserkDestroyEffect() {
        super(Outcome.Benefit);
        this.staticText = "At the beginning of the next end step, destroy that creature if it attacked this turn";
    }

    private BerserkDestroyEffect(BerserkDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BerserkDestroyEffect copy() {
        return new BerserkDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        BerserkDelayedDestroyEffect effect = new BerserkDelayedDestroyEffect();
        effect.setTargetPointer((TargetPointer)new FixedTarget(this.getTargetPointer().getFirst(game, source), game));
        AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
        return true;
    }
}

