/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BetrayEffect
extends OneShotEffect {
    BetrayEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature an opponent controls deals damage to its controller equal to that creature's power.";
    }

    private BetrayEffect(BetrayEffect effect) {
        super((OneShotEffect)effect);
    }

    public BetrayEffect copy() {
        return new BetrayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        return player.damage(permanent.getPower().getValue(), permanent.getId(), source, game) > 0;
    }
}

