/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BindTheMonsterEffect
extends OneShotEffect {
    BindTheMonsterEffect() {
        super(Outcome.Tap);
        this.staticText = "tap enchanted creature. It deals damage to you equal to its power";
    }

    private BindTheMonsterEffect(BindTheMonsterEffect effect) {
        super((OneShotEffect)effect);
    }

    public BindTheMonsterEffect copy() {
        return new BindTheMonsterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature;
        Permanent attachment = source.getSourcePermanentOrLKI(game);
        if (attachment != null && (creature = game.getPermanent(attachment.getAttachedTo())) != null) {
            creature.tap(source, game);
            Player player = game.getPlayer(source.getControllerId());
            if (player != null) {
                player.damage(creature.getPower().getValue(), creature.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

