/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BioessenceHydraTriggeredAbility
extends TriggeredAbilityImpl {
    BioessenceHydraTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()), false);
    }

    private BioessenceHydraTriggeredAbility(BioessenceHydraTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BioessenceHydraTriggeredAbility copy() {
        return new BioessenceHydraTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getData().equals(CounterType.LOYALTY.getName()) && event.getAmount() > 0) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (permanent == null) {
                permanent = game.getPermanentEntering(event.getTargetId());
            }
            if (permanent != null && !event.getTargetId().equals(this.getSourceId()) && permanent.isPlaneswalker(game) && permanent.isControlledBy(this.getControllerId())) {
                this.getEffects().clear();
                if (event.getAmount() > 0) {
                    this.addEffect((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(event.getAmount())));
                }
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever one or more loyalty counters are put on a planeswalker you control, put that many +1/+1 counters on {this}.";
    }
}

