/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.players.Player;

class BiorhythmEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public BiorhythmEffect() {
        super(Outcome.Neutral);
        this.staticText = "Each player's life total becomes the number of creatures they control";
    }

    private BiorhythmEffect(BiorhythmEffect effect) {
        super((OneShotEffect)effect);
    }

    public BiorhythmEffect copy() {
        return new BiorhythmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            int diff = player.getLife() - game.getBattlefield().countAll((FilterPermanent)filter, playerId, game);
            if (diff > 0) {
                player.loseLife(diff, game, source, false);
            }
            if (diff >= 0) continue;
            player.gainLife(-diff, game, source);
        }
        return true;
    }
}

