/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.command.Commander;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class BiotransferenceEffect
extends ContinuousEffectImpl {
    BiotransferenceEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "Creatures you control are artifacts in addition to their other types. The same is true for creature spells you control and creature cards you own that aren't on the battlefield";
        this.dependencyTypes.add(DependencyType.ArtifactAddingRemoving);
    }

    private BiotransferenceEffect(BiotransferenceEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public BiotransferenceEffect copy() {
        return new BiotransferenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID cardId : controller.getGraveyard()) {
            card = game.getCard(cardId);
            if (card == null || !card.isCreature(game) || card.isArtifact(game)) continue;
            card.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        for (UUID cardId : controller.getHand()) {
            card = game.getCard(cardId);
            if (card == null || !card.isCreature(game) || card.isArtifact(game)) continue;
            card.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        for (Card card2 : game.getState().getExile().getCardsOwned(game, source.getControllerId())) {
            if (!card2.isCreature(game) || card2.isArtifact(game)) continue;
            card2.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        for (Card card2 : controller.getLibrary().getCards(game)) {
            if (!card2.isOwnedBy(controller.getId()) || !card2.isCreature(game) || card2.isArtifact(game)) continue;
            card2.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        for (CommandObject commandObject : game.getState().getCommand()) {
            if (!(commandObject instanceof Commander) || (card = game.getCard(commandObject.getId())) == null || !card.isOwnedBy(controller.getId()) || !card.isCreature(game) || card.isArtifact(game)) continue;
            card.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || !stackObject.isControlledBy(source.getControllerId()) || !stackObject.isCreature(game) || stackObject.isArtifact(game)) continue;
            card = ((Spell)stackObject).getCard();
            card.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        List creatures = game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterControlledCreaturePermanent(), source.getControllerId(), game);
        for (Permanent creature : creatures) {
            if (creature == null) continue;
            creature.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        return true;
    }
}

