/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetSacrifice;

class BirthingRitualEffect
extends OneShotEffect {
    BirthingRitualEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top seven cards of your library. Then you may sacrifice a creature. If you do, you may put a creature card with mana value X or less from among those cards onto the battlefield, where X is 1 plus the sacrificed creature's mana value. Put the rest on the bottom of your library in a random order.";
    }

    private BirthingRitualEffect(BirthingRitualEffect effect) {
        super((OneShotEffect)effect);
    }

    public BirthingRitualEffect copy() {
        return new BirthingRitualEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 7));
        controller.lookAtCards(source, null, (Cards)cards, game);
        TargetSacrifice sacrificeTarget = new TargetSacrifice(0, 1, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
        controller.choose(Outcome.Sacrifice, (Target)sacrificeTarget, source, game);
        Permanent sacrificed = game.getPermanent(sacrificeTarget.getFirstTarget());
        if (sacrificed == null || !sacrificed.sacrifice(source, game)) {
            return this.endOfApply((Cards)cards, controller, game, source);
        }
        int mv = 1 + sacrificed.getManaValue();
        game.processAction();
        FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value " + mv + " or less");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, mv));
        TargetCard target = new TargetCard(0, 1, Zone.LIBRARY, (FilterCard)filter);
        target.withNotTarget(true);
        controller.choose(Outcome.PutCreatureInPlay, (Cards)cards, target, source, game);
        Set putIntoPlay = target.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        controller.moveCards(putIntoPlay, Zone.BATTLEFIELD, source, game);
        return this.endOfApply((Cards)cards, controller, game, source);
    }

    private boolean endOfApply(Cards cards, Player controller, Game game, Ability source) {
        cards.retainZone(Zone.LIBRARY, game);
        controller.putCardsOnBottomOfLibrary(cards, game, source, false);
        return true;
    }
}

