/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.CardUtil;

class BitterFeudEffect
extends ReplacementEffectImpl {
    private Player player1;
    private Player player2;

    public BitterFeudEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a source controlled by one of the chosen players would deal damage to the other chosen player or a permanent that player controls, that source deals double that damage to that player or permanent instead";
    }

    private BitterFeudEffect(BitterFeudEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.player1 = effect.player1;
        this.player2 = effect.player2;
    }

    public BitterFeudEffect copy() {
        return new BitterFeudEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT && event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        UUID sourcePlayerId;
        UUID targetPlayerId;
        this.player1 = (Player)game.getState().getValue(source.getSourceId() + "_player1");
        if (this.player1 == null) {
            return false;
        }
        this.player2 = (Player)game.getState().getValue(source.getSourceId() + "_player2");
        if (this.player2 == null) {
            return false;
        }
        switch (event.getType()) {
            case DAMAGE_PLAYER: {
                targetPlayerId = event.getTargetId();
                break;
            }
            case DAMAGE_PERMANENT: {
                Permanent permanent = game.getPermanent(event.getTargetId());
                if (permanent == null) {
                    return false;
                }
                targetPlayerId = permanent.getControllerId();
                break;
            }
            default: {
                return false;
            }
        }
        if (!this.player1.getId().equals(targetPlayerId) && !this.player2.getId().equals(targetPlayerId)) {
            return false;
        }
        MageObject damageSource = game.getObject(event.getSourceId());
        if (damageSource instanceof StackObject) {
            sourcePlayerId = ((StackObject)damageSource).getControllerId();
        } else if (damageSource instanceof Permanent) {
            sourcePlayerId = ((Permanent)damageSource).getControllerId();
        } else if (damageSource instanceof Card) {
            sourcePlayerId = ((Card)damageSource).getOwnerId();
        } else {
            return false;
        }
        return sourcePlayerId != null && (this.player1.getId().equals(sourcePlayerId) || this.player2.getId().equals(sourcePlayerId)) && !sourcePlayerId.equals(targetPlayerId);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

