/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class BlackSunsZenithEffect
extends OneShotEffect {
    BlackSunsZenithEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Put X -1/-1 counters on each creature";
    }

    private BlackSunsZenithEffect(BlackSunsZenithEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents()) {
            if (permanent == null || !permanent.isCreature(game)) continue;
            permanent.addCounters(CounterType.M1M1.createInstance(amount), source.getControllerId(), source, game);
        }
        return true;
    }

    public BlackSunsZenithEffect copy() {
        return new BlackSunsZenithEffect(this);
    }
}

