/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class BlazingEffigyWatcher
extends Watcher {
    private final Map<MageObjectReference, Integer> damagedObjects = new HashMap<MageObjectReference, Integer>();

    public BlazingEffigyWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PERMANENT) {
            return;
        }
        if (event.getSourceId().equals(event.getTargetId())) {
            return;
        }
        MageObjectReference damageSourceRef = new MageObjectReference(event.getSourceId(), game);
        MageObjectReference damageTargetRef = new MageObjectReference(event.getTargetId(), game);
        if (game.getPermanentOrLKIBattlefield(event.getSourceId()) != null && game.getPermanentOrLKIBattlefield(event.getSourceId()).getName().equals("Blazing Effigy")) {
            this.damagedObjects.putIfAbsent(damageTargetRef, 0);
            this.damagedObjects.compute(damageTargetRef, (k, damage) -> damage + event.getAmount());
        }
    }

    public void reset() {
        super.reset();
        this.damagedObjects.clear();
    }

    public int damageDoneTo(UUID objectId, int zoneChangeCounter, Game game) {
        MageObjectReference mor = new MageObjectReference(objectId, zoneChangeCounter, game);
        return this.damagedObjects.getOrDefault(mor, 0);
    }
}

