/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BlazingSalvoEffect
extends OneShotEffect {
    BlazingSalvoEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 3 damage to target creature unless that creature's controller has {this} deal 5 damage to them";
    }

    private BlazingSalvoEffect(BlazingSalvoEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlazingSalvoEffect copy() {
        return new BlazingSalvoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && (player = game.getPlayer(permanent.getControllerId())) != null) {
            String message = "Have Blazing Salvo do 5 damage to you?";
            if (player.chooseUse(Outcome.Damage, message, source, game)) {
                player.damage(5, source.getSourceId(), source, game);
            } else {
                permanent.damage(3, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

