/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.RandomUtil;

class BlitzwingAdaptiveAssailantEffect
extends OneShotEffect {
    BlitzwingAdaptiveAssailantEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose flying or indestructible at random. {this} gains that ability until end of turn";
    }

    private BlitzwingAdaptiveAssailantEffect(BlitzwingAdaptiveAssailantEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlitzwingAdaptiveAssailantEffect copy() {
        return new BlitzwingAdaptiveAssailantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FlyingAbility ability = RandomUtil.nextBoolean() ? FlyingAbility.getInstance() : IndestructibleAbility.getInstance();
        game.informPlayers(ability.getRule() + " has been chosen");
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)ability, Duration.EndOfTurn), source);
        return true;
    }
}

