/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AddContinuousEffectToGame;
import mage.abilities.effects.common.FightTargetsEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledCreaturePermanent;

public final class BlizzardBrawl
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("you control three or more snow permanents");
    private static final Condition condition;

    public BlizzardBrawl(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{G}");
        this.supertype.add(SuperType.SNOW);
        this.getSpellAbility().addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new AddContinuousEffectToGame(new ContinuousEffect[]{new BoostTargetEffect(1, 0)}), condition, "Choose target creature you control and target creature you don't control. If you control three or more snow permanents, the creature you control gets +1/+0 and gains indestructible until end of turn.").addEffect((OneShotEffect)new AddContinuousEffectToGame(new ContinuousEffect[]{new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance())})));
        this.getSpellAbility().addEffect((Effect)new FightTargetsEffect().setText("Then those creatures fight each other. <i>(Each deals damage equal to its power to the other.)</i>"));
        this.getSpellAbility().addTarget((Target)new TargetControlledCreaturePermanent());
        this.getSpellAbility().addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL));
    }

    private BlizzardBrawl(BlizzardBrawl card) {
        super((CardImpl)card);
    }

    public BlizzardBrawl copy() {
        return new BlizzardBrawl(this);
    }

    static {
        filter.add((Predicate)SuperType.SNOW.getPredicate());
        condition = new PermanentsOnTheBattlefieldCondition(filter, ComparisonType.MORE_THAN, 2);
    }
}

