/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BloodBaronOfVizkopaEffect
extends ContinuousEffectImpl {
    BloodBaronOfVizkopaEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "As long as you have 30 or more life and an opponent has 10 or less life, {this} gets +6/+6 and has flying";
    }

    private BloodBaronOfVizkopaEffect(BloodBaronOfVizkopaEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public BloodBaronOfVizkopaEffect copy() {
        return new BloodBaronOfVizkopaEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        if (!this.conditionState(source, game)) {
            return false;
        }
        Permanent creature = game.getPermanent(source.getSourceId());
        if (creature == null) {
            return false;
        }
        switch (layer) {
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.ModifyPT_7c) break;
                creature.addPower(6);
                creature.addToughness(6);
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                if (sublayer != SubLayer.NA) break;
                creature.addAbility((Ability)FlyingAbility.getInstance(), source.getSourceId(), game);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean conditionState(Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || controller.getLife() < 30) {
            return false;
        }
        for (UUID opponentId : game.getOpponents(controller.getId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !opponent.isInGame() || opponent.getLife() > 10) continue;
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.PTChangingEffects_7;
    }
}

