/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.events.GameEvent;

class BloodFrenzyCastRestriction
extends ContinuousRuleModifyingEffectImpl {
    BloodFrenzyCastRestriction() {
        super(Duration.EndOfGame, Outcome.Detriment);
        this.staticText = "Cast this spell only before the combat damage step";
    }

    private BloodFrenzyCastRestriction(BloodFrenzyCastRestriction effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public BloodFrenzyCastRestriction copy() {
        return new BloodFrenzyCastRestriction(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getSourceId().equals(source.getSourceId())) {
            return game.getTurnPhaseType() != TurnPhase.COMBAT || game.getTurnStepType() != PhaseStep.DECLARE_ATTACKERS && game.getTurnStepType() != PhaseStep.DECLARE_BLOCKERS;
        }
        return false;
    }
}

