/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class BloodOathEffect
extends OneShotEffect {
    private static final Set<String> choice = new LinkedHashSet<String>();

    public BloodOathEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a card type. Target opponent reveals their hand. {this} deals 3 damage to that player for each card of the chosen type revealed this way";
    }

    private BloodOathEffect(BloodOathEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodOathEffect copy() {
        return new BloodOathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        Player player = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (player != null && opponent != null && sourceObject != null) {
            ChoiceImpl choiceImpl = new ChoiceImpl(true);
            choiceImpl.setChoices(choice);
            if (player.choose(Outcome.Neutral, (Choice)choiceImpl, game)) {
                CardType type = null;
                String chosenType = choiceImpl.getChoice();
                if (chosenType.equals(CardType.ARTIFACT.toString())) {
                    type = CardType.ARTIFACT;
                } else if (chosenType.equals(CardType.LAND.toString())) {
                    type = CardType.LAND;
                } else if (chosenType.equals(CardType.CREATURE.toString())) {
                    type = CardType.CREATURE;
                } else if (chosenType.equals(CardType.ENCHANTMENT.toString())) {
                    type = CardType.ENCHANTMENT;
                } else if (chosenType.equals(CardType.INSTANT.toString())) {
                    type = CardType.INSTANT;
                } else if (chosenType.equals(CardType.SORCERY.toString())) {
                    type = CardType.SORCERY;
                } else if (chosenType.equals(CardType.PLANESWALKER.toString())) {
                    type = CardType.PLANESWALKER;
                } else if (chosenType.equals(CardType.KINDRED.toString())) {
                    type = CardType.KINDRED;
                }
                if (type != null) {
                    Cards hand = opponent.getHand();
                    opponent.revealCards(sourceObject.getIdName(), hand, game);
                    Set cards = hand.getCards(game);
                    int damageToDeal = 0;
                    for (Card card : cards) {
                        if (card == null || !card.getCardType(game).contains(type)) continue;
                        damageToDeal += 3;
                    }
                    game.informPlayers(sourceObject.getLogName() + " deals " + (damageToDeal == 0 ? "no" : "" + damageToDeal) + " damage to " + opponent.getLogName());
                    opponent.damage(damageToDeal, source.getSourceId(), source, game);
                    return true;
                }
            }
        }
        return false;
    }

    static {
        choice.add(CardType.ARTIFACT.toString());
        choice.add(CardType.CREATURE.toString());
        choice.add(CardType.ENCHANTMENT.toString());
        choice.add(CardType.INSTANT.toString());
        choice.add(CardType.LAND.toString());
        choice.add(CardType.PLANESWALKER.toString());
        choice.add(CardType.SORCERY.toString());
        choice.add(CardType.KINDRED.toString());
    }
}

