/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.DiesOneOrMoreTriggeredAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceHasCounterCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.effects.common.MillCardsControllerEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToHandTargetEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetOpponentsCreaturePermanent;

public final class BloodSpatterAnalysis
extends CardImpl {
    private static final Condition condition = new SourceHasCounterCondition(CounterType.BLOODSTAIN, 5);

    public BloodSpatterAnalysis(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{B}{R}");
        EntersBattlefieldTriggeredAbility ability = new EntersBattlefieldTriggeredAbility((Effect)new DamageTargetEffect(3));
        ability.addTarget((Target)new TargetOpponentsCreaturePermanent());
        this.addAbility((Ability)ability);
        ability = new DiesOneOrMoreTriggeredAbility((Effect)new MillCardsControllerEffect(1), StaticFilters.FILTER_PERMANENT_CREATURES, false);
        ability.addEffect((Effect)new AddCountersSourceEffect(CounterType.BLOODSTAIN.createInstance()).concatBy("and"));
        ReflexiveTriggeredAbility returnAbility = new ReflexiveTriggeredAbility((Effect)new ReturnFromGraveyardToHandTargetEffect(), false);
        returnAbility.addTarget((Target)new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD));
        ability.addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new DoWhenCostPaid(returnAbility, (Cost)new SacrificeSourceCost(), null, false), condition).setText("Then sacrifice it if it has five or more bloodstain counters on it. When you do, return target creature card from your graveyard to your hand"));
        this.addAbility((Ability)ability);
    }

    private BloodSpatterAnalysis(BloodSpatterAnalysis card) {
        super((CardImpl)card);
    }

    public BloodSpatterAnalysis copy() {
        return new BloodSpatterAnalysis(this);
    }
}

