/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class BloodbondMarchEffect
extends OneShotEffect {
    BloodbondMarchEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player returns all cards with the same name as that spell from their graveyard to the battlefield";
    }

    private BloodbondMarchEffect(BloodbondMarchEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || game.getPermanentOrLKIBattlefield(source.getSourceId()) == null) {
            return false;
        }
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new NamePredicate(spell.getName()));
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.moveCards(player.getGraveyard().getCards(filter, game), Zone.BATTLEFIELD, source, game);
        }
        return true;
    }

    public BloodbondMarchEffect copy() {
        return new BloodbondMarchEffect(this);
    }
}

